
/***************************************************************************
 *   Copyright (C) 2008-2009 by Manuel Schrape                             *
 *   manuel.schrape@gmx.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License.        *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CQMK_SERVER_H
#define CQMK_SERVER_H

#include <QString>
#include <QTcpSocket>
#include <QStringList>

#include "../global.h"

class cQMK_Server : public QObject
{
    Q_OBJECT

    public:
        cQMK_Server();
        void Connect(QString IP, int Port, QString User, QString Pass);
        void Disconnect();
        void NewPosition(sNaviString Pos);
        void send_RawData(QString Data);

    private:
        //TCP-Socket
        QTcpSocket *TcpSocket;
        QString Username;
        QString Password;
        void SendData(int CMD, QString Data);

    private slots:
        void slot_Connected();
        void slot_Disconnect();
        void slot_ReadLine();
        void slot_Error(QAbstractSocket::SocketError Error);

    signals:
        void sig_Connected();
        void sig_Disconnected(int Error);
};

#endif // CQMK_SERVER_H
